"use client";

import { useState, useEffect } from "react";
import { StatCard } from "@/components/ui/stat-card";
import { WeeklySchedule } from "@/components/dashboard/WeeklySchedule";
import { Skeleton } from "@/components/ui/skeleton";
import { Users, Calendar, BookOpen, GraduationCap } from "lucide-react";

export default function Home() {
  const [stats, setStats] = useState<any>(null);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    fetchStats();
  }, []);

  const fetchStats = async () => {
    try {
      const res = await fetch('/api/stats');
      const data = await res.json();
      setStats(data);
    } catch (error) {
      console.error('Failed to fetch stats:', error);
    } finally {
      setLoading(false);
    }
  };

  return (
    <div className="space-y-6 animate-fade-in">
      {/* Page Header */}
      <div>
        <h1 className="text-2xl font-heading font-bold text-foreground">Dashboard</h1>
        <p className="text-muted-foreground">Welcome back! Here's your school roster overview.</p>
      </div>

      {/* Stats Grid */}
      <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
        {loading ? (
          Array.from({ length: 4 }).map((_, i) => (
            <div key={i} className="rounded-xl bg-card shadow-card p-6">
              <div className="space-y-3">
                <Skeleton className="h-4 w-24" />
                <Skeleton className="h-8 w-16" />
                <Skeleton className="h-3 w-32" />
              </div>
            </div>
          ))
        ) : (
          <>
            <StatCard
              title="Total Teachers"
              value={stats?.totalTeachers || 0}
              subtitle="Active staff members"
              icon={Users}
              variant="primary"
            />
            <StatCard
              title="Classes Today"
              value={stats?.schedulesToday || 0}
              subtitle="Scheduled sessions"
              icon={Calendar}
              variant="accent"
            />
            <StatCard
              title="Total Sections"
              value={stats?.totalSections || 0}
              subtitle={`${stats?.totalClasses || 0} classes`}
              icon={GraduationCap}
              variant="default"
            />
            <StatCard
              title="Subjects"
              value={stats?.totalSubjects || 0}
              subtitle="Available courses"
              icon={BookOpen}
              variant="default"
            />
          </>
        )}
      </div>

      {/* Main Content */}
      <WeeklySchedule />
    </div>
  );
}
