"use client";

import { WeeklySchedule } from "@/components/dashboard/WeeklySchedule";
import { Button } from "@/components/ui/button";
import { Plus, ChevronLeft, ChevronRight, Calendar } from "lucide-react";

export default function Schedule() {
    return (
        <div className="space-y-6 animate-fade-in">
            {/* Page Header */}
            <div className="flex flex-col sm:flex-row sm:items-center justify-between gap-4">
                <div>
                    <h1 className="text-2xl font-heading font-bold text-foreground">Schedule</h1>
                    <p className="text-muted-foreground">View and manage class schedules</p>
                </div>
                <div className="flex gap-2">
                    <Button variant="outline" className="gap-2">
                        <Calendar className="h-4 w-4" />
                        Today
                    </Button>
                    <Button className="gap-2">
                        <Plus className="h-4 w-4" />
                        Add Class
                    </Button>
                </div>
            </div>

            {/* Week Navigation */}
            <div className="flex items-center justify-between">
                <Button variant="ghost" size="sm" className="gap-1">
                    <ChevronLeft className="h-4 w-4" />
                    Previous Week
                </Button>
                <div className="text-center">
                    <h2 className="font-semibold">January 27 - January 31, 2026</h2>
                    <p className="text-sm text-muted-foreground">Week 5</p>
                </div>
                <Button variant="ghost" size="sm" className="gap-1">
                    Next Week
                    <ChevronRight className="h-4 w-4" />
                </Button>
            </div>

            {/* Schedule Grid */}
            <WeeklySchedule />
        </div>
    );
}
